﻿var nowPage = 1;
var maxItem = 20;
var maxIndex = 0;
var SelectedItems = $([]), offset = { top: 0, left: 0 };

function EventBind() {
    var editorWidth = parseInt($(".pagePreview").css("width"));
    var pageWidth = parseInt($("#l-page-1").css("width"));
    var marginLeft;
    if (editorWidth / 2 > pageWidth) {
        marginLeft = (parseInt(editorWidth - pageWidth * 2) / 3);
    } else {
        marginLeft = (editorWidth - pageWidth) / 2;
    }
    $(".pagec").css("margin-left", marginLeft);

    $(".pageContent").selectable();
    $(".pageContent").on("selectablestart", function (event, ui) {
        SelectedItems = $([]);
        $(".preimg").removeClass("ui-selected");
    });
    $(".pageContent").on("selectableselected", function (event, ui) {
        SelectedItems.push($(ui.selected));
    });
    $(".pageContent").on("selectablestop", function (event, ui) {
        $(".inputtext").removeClass("selectedtext");
        $.each(SelectedItems, function (n, v) {
            var rid = "r" + $(v).attr("id").substring(1);
            $("#" + rid).addClass("selectedtext");
        });
        if (SelectedItems.length > 1) {
            $("#editorTools").show();
        }
    });

    var TimeFn = null;
    $(".preimg").click(function (e) {
        clearTimeout(TimeFn);
        TimeFn = setTimeout("", 300);
        if (e.metaKey == false) {
            $(".preimg").removeClass("ui-selected");
            SelectedItems = $([]);
            SelectedItems.push($(this));
            $(this).addClass("ui-selected");
            $(".inputtext").removeClass("selectedtext");
            var rid = "r" + $(this).attr("id").substring(1);
            $("#" + rid).addClass("selectedtext");
            SetFontStyle($(this).attr("id").split('-')[2], $(this).attr("id").split('-')[4]);
        }      
    });
    $(".preimg").draggable({ containment: "parent" });
    $(".preimg").on("dragstart", function (event, ui) {
        if ($(this).hasClass("ui-selected")) {
            SelectedItems = $(".ui-selected").each(function () {
                var el = $(this);
                el.data("offset", el.offset());
            });
        }
        else {
            SelectedItems = $([]);
            $(".pageContent .preimg").removeClass("ui-selected");
        }
        offset = $(this).offset();
    });
    $(".preimg").on("drag", function (event, ui) {
        var dt = ui.position.top - offset.top, dl = ui.position.left - offset.left;
        if (SelectedItems.length > 0) {
            $.each(SelectedItems, function (n, v) {
                var el = $(v), off = el.data("offset");
                el.css({ top: off.top + dt, left: off.left + dl });
                var rightItemId = "#r" + $(el).attr("id").substring(1);
                $(rightItemId).attr("y", off.top + dt);
                $(rightItemId).attr("x", off.left + dl);
            });
        } else {
            var el = $(this), off = $(this).data("offset");
            var rightItemId = "#r" + $(el).attr("id").substring(1);
            $(rightItemId).attr("y", el.css("top"));
            $(rightItemId).attr("x", el.css("left"));
        }
    });
    $(".preimg").on("dragstop", function (event, ui) {
        var dt = ui.position.top - offset.top, dl = ui.position.left - offset.left;
        if (SelectedItems.length > 0) {
            $.each(SelectedItems, function (n, v) {
                var el = $(v), off = el.data("offset");
                el.css({ top: off.top + dt, left: off.left + dl });
                var rightItemId = "#r" + $(el).attr("id").substring(1);
                $(rightItemId).attr("y", off.top + dt);
                $(rightItemId).attr("x", off.left + dl);
            });
        } else {
            var el = $(this), off = $(this).data("offset");
            var rightItemId = "#r" + $(el).attr("id").substring(1);
            $(rightItemId).attr("y", el.css("top"));
            $(rightItemId).attr("x", el.css("left"));
        }
    });

    $(".slider").slider({
        min: 0,
        max: 300,
        value: 100,
        stop: function (event, ui) {
            ResizeImage($(this).attr("id"), ui.value);
        },
        slide: function (event, ui) {
            ResizeImage($(this).attr("id"), ui.value);
        }
    });
    $("#SetFontStyleTool select").change(function () {
        ChangeFontStyle();
    });
    $("#SetFontStyleTool input[type=checkbox]").change(function () {
        ChangeFontStyle();
    });
    $(document).keydown(function (event) {
        MoveSelectItems(event);
    });
    $("#isround").click(function () {
        if (this.checked) {
            $(".pageBackground strong").show();
        } else {
            $(".pageBackground strong").hide();
        }
    });
}
function MoveSelectItems(event) {
    if (event.which == 37 || event.which == 38 || event.which == 39 || event.which == 40) {
        var id = event.which;
        if (event && event.preventDefault)
            event.preventDefault();
        else
            window.event.returnValue = false;
        var maxWidth = parseInt($(".pageContent").css("width"));
        var maxHeighth = parseInt($(".pageContent").css("height"));
        switch (id) {
            case 37:
                $.each(SelectedItems, function (n, v) {
                    var robj = "#r"+$(v).attr("id").substring(1);
                    if (parseInt($(v).css("left")) == 0) {
                        $(v).css("left", 0);
                        $(robj).attr("x",0);
                    } else {
                        $(v).css("left", parseInt($(v).css("left")) - 1);
                        $(robj).attr("x", parseInt($(v).css("left")) - 1);
                    }
                });
                break;
            case 38:
                $.each(SelectedItems, function (n, v) {
                    var robj = "#r" + $(v).attr("id").substring(1);
                    if (parseInt($(v).css("top")) == 0) {
                        $(v).css("top", 0);
                        $(robj).attr("y", 0);
                    } else {
                        $(v).css("top", parseInt($(v).css("top")) - 1);
                        $(robj).attr("y", parseInt($(v).css("top")) - 1);
                    }
                });
                break;
            case 39:
                $.each(SelectedItems, function (n, v) {
                    var robj = "#r"+$(v).attr("id").substring(1);
                    if (parseInt($(v).css("left")) > parseInt(maxWidth - $(v).get(0).offsetWidth)) {
                        $(v).css("left", parseInt(maxWidth - $(v).get(0).offsetWidth));
                        $(robj).attr("x", parseInt(maxWidth - $(v).get(0).offsetWidth));
                    } else {
                        $(v).css("left", parseInt($(v).css("left")) + 1);
                        $(robj).attr("x", parseInt($(v).css("left")) + 1);
                    }

                });
                break;
            case 40:
                $.each(SelectedItems, function (n, v) {
                    var robj = "#r" + $(v).attr("id").substring(1);
                    if (parseInt($(v).css("top")) > parseInt(maxHeighth - $(v).get(0).offsetHeight)) {
                        $(v).css("top", parseInt(maxHeighth - $(v).get(0).offsetHeight));
                        $(robj).attr("y", parseInt(maxHeighth - $(v).get(0).offsetHeight));
                    } else {
                        $(v).css("top", parseInt($(v).css("top")) + 1);
                        $(robj).attr("y", parseInt($(v).css("top")) + 1);
                    }
                });
                break;
        }
    }
}
function Tempe() {
    this.Pages = ([]);
    this.Name = "测试模板";
    this.TemplateId = 0;
    this.Pass = "admin";
    this.Addtime = "2013";
    this.Id = 0;
    this.ProductTypeId = 3;
    this.SizeId = 1;
    this.GroupId = 1;
    this.Status = false;
    this.FilePath = "";
    this.IsRound = false;
}
function Saveewmdata(type){
    var  array = [];

    array.push($("#FN").val());
    array.push($("#TEL").val());
    array.push($("#ADR").val());array.push($("#NICKNAME").val());array.push($("#QQ").val());array.push($("#TITLE").val());array.push($("#ORG").val());array.push($("#EMAIL").val());array.push($("#URL").val());
    
    
    
    
    
    var result = array.join();
   
    return result;
}
function Template() {
    this.Pages = ([]);
    this.Name = "测试模板";
    this.TemplateId = 0;
    this.Author = "admin";
    this.Addtime = "2013";
    this.Id = 0;
    this.ProductTypeId = 3;
    this.SizeId = 1;
    this.GroupId = 1;
    this.Status = false;
    this.FilePath = "";
    this.IsRound = false;
}
function TemplatePage() {
    this.Background = "";
    this.Texts = ([]);
    this.Images = ([]);
    this.Number = 0;
    this.Thumb = "";
    this.PDF = "";
}
function TextItem() {
    this.Text = "";
    this.CMYKColor = "";
    this.RGBColor = "";
    this.MultiLine = false;
    this.FontName = "";
    this.FontSize = 0;
    this.Fontstyle = "normal";
    this.Fontweight = "normal";
    this.Left = 0;
    this.Top = 0;
    this.ZIndex = 0;
    this.TextTag = 0;
    this.WordSpace = "0";
    this.Width = 400;
    this.Height = 243;
    this.Textdirection = "0";
    this.HAlignType = "";
    this.HAlignValue = "";
    this.VAlignType = "";
    this.VAlignValue = "";
}
function ImageItem() {
    this.Width = 0;
    this.Height = 0;
    this.Left = 0;
    this.Top = 0;
    this.ImageUrl = "";
    this.Percent = 100;
    this.Imagetype = "1";
    this.ZIndex = 10;
    this.HAlignType = "";
    this.HAlignValue = "";
    this.VAlignType = "";
    this.VAlignValue = "";
}

function LoadTemplate() {
    var pagecount = $(".pageItem").length;
    for (i = 0; i < pagecount; i++) {
        var page = i + 1;
        var textItemCount = $("#r-page-" + page + " .textitem").length;
        for (j = 0; j < textItemCount; j++) {
            var number = j + 1;
            GetText(page, number);
        }
    }
}

function SelectPage(page) {
    $(".pagenav li").removeClass("select");
    $("#page-title-" + page).addClass("select");
    $(".pageItem").hide();
    $("#r-page-" + page).show();
    $(".pagec").removeClass("selectedpage");
    $("#l-page-" + page).addClass("selectedpage");
    nowPage = page;
    maxIndex = 0;
    maxItem = $("#r-page-" + page+" .textitem").length + $("#r-page-" + page+" .logoitem").length;
    $.each($("#l-page-" + page + " .pageContent img"), function (n, v) {
        if (parseInt($(v).css("z-index")) > maxIndex)
            maxIndex = parseInt($(v).css("z-index"));
    })
}

function SetAdvantageTools() {
    if ($("#AdvantageTools").prop("checked")) {
        OpenAdvantageTools();
    } else {
        CloseAdvantageTools();
    }
}
function OpenAdvantageTools() {
    $("#AdvantageTools").prop("checked", true);
    $("#editorTools").show();
    $("#AdvantageTips span").text("隐藏高级功能");
}
function CloseAdvantageTools() {
    $("#AdvantageTools").prop("checked", false);
    $("#editorTools").hide();
    $("#AdvantageTips span").text("显示高级功能");
}

function SetRound() {
    //if ($("input[id='isround']").is(':checked')) {
    //        $(".pageBackground b").show();
    //    } else {
    //        $(".pageBackground b").hide();
    //}
    $("#isround").click(function () {
        if (this.checked) {
            $(".pageBackground strong").show();
        } else {
            $(".pageBackground strong").hide();
        }
    });
    //if ($("input[id='isround']").is(':checked')) {
    //    $(".pageBackground").addClass("round");
    //} else {
    //    $(".pageBackground").removeClass("round");
    //}
}

function DeleteItem(page, type, number) {   
    $("#l-page-" + page + "-" + type + "-" + number).remove();
    if (type == "text") {
        var obj = $("#SetFontStyleTool");
        obj.hide();
        $("body").append(obj);
        $("#r-page-" + page + "-" + type + "-" + number).parent().remove();
    } else {
        $("#r-page-" + page + "-" + type + "-" + number).parent().parent().remove();
    }
    maxItem = maxItem - 1;
}

function ShowLogoList(page,number) {
    art.dialog.open(("uc/u.php?productId=" + $("#hideProductId").val() + "&sizeId=" + $("#hideSizeId").val()),
    {
        id:"showlogolist",
        title: "Logo选择",
        ok: function () {
            var bValue = art.dialog.data("bValue");
            var logo = $.evalJSON(bValue);
            var imgthumb = new Image();
            imgthumb.src = logo.thumbpath;
            imgthumb.onload = function () {
                if (imgthumb.complete == true) {
                    var width = imgthumb.width;
                    var height = imgthumb.height;
                    $("#r-page-" + page + "-image-" + number).attr("src", logo.thumbpath);
                    $("#r-page-" + page + "-image-" + number).attr("w", width);
                    $("#r-page-" + page + "-image-" + number).attr("h", height);
                    $("#r-page-" + page + "-image-" + number).attr("ow", width);
                    $("#r-page-" + page + "-image-" + number).attr("oh", height);
                    $("#l-page-" + page + "-image-" + number).css("width", width);
                    $("#l-page-" + page + "-image-" + number).css("height", height);
                }
            }
            var imgoriginal = new Image();
            imgoriginal.src = logo.originalpath;
            imgoriginal.onload = function () {
                if (imgoriginal.complete == true) {
                    $("#l-page-" + page + "-image-" + number).attr("src", logo.originalpath);
                }
            }
        }
    });
    

    //$.dialog({
    //    follow: document.getElementById('r-page-' + page + '-choose-' + number),
    //    content: '让对话框跟着某个元素，一个元素同时只能出现一个对话框'
    //});
}
function UploadLogo(page, index) {
    var productId = 500;
    var sizeId=100;
    art.dialog.open("uc/u.php?ProductId=" + productId + "&SizeId=" + sizeId, {
        id: "logouploadiframe",
        title: '选图片',
        width:500,
        ok: function () {
            var bValue = art.dialog.data("bValue");
            var img = new Image();
            img.src = bValue;
            img.onload = function () {
                if (img.complete == true) {
                    var width = img.width;
                    var height = img.height;
                    $("#r-page-" + page + "-image-" + index).attr("src", bValue);
                    $("#r-page-" + page + "-image-" + index).attr("w", width);
                    $("#r-page-" + page + "-image-" + index).attr("h", height);
                    $("#r-page-" + page + "-image-" + index).attr("ow", width);
                    $("#r-page-" + page + "-image-" + index).attr("oh", height);

                    $("#l-page-" + page + "-image-" + index).attr("src", bValue);
                    $("#l-page-" + page + "-image-" + index).css("width", width);
                    $("#l-page-" + page + "-image-" + index).css("height", height);
                }
            }
        },
        cancel: function () {

        }
    });
}
function AddNewLogo() {
    var productId = $("#hideProductId").val();
    var sizeId = $("#hideSizeId").val();
    art.dialog.open("uc/u.php?ProductId=" + productId + "&SizeId=" + sizeId, {
        id: "newlogouploadiframe",
        title: '选图片',
        width: 500,
        ok: function () {
            var bValue = art.dialog.data("bValue");
            var img = new Image();
            img.src = bValue;
            img.onload = function () {
                if (img.complete == true) {
                    var width = img.width;
                    var height = img.height;

                    maxItem++;
                    maxIndex++;
                    var imgstr = "<li class=\"logoitem\">" +
                        "<div class=\"logoleft\">" +
                            "<img src=\"" + bValue + "\" id=\"r-page-" + nowPage + "-image-" + maxItem + "\" ow=\"" + width + "\" oh=\"" + height + "\" w=\"" + width + "\" h=\"" + height + "\" t=\"1\" x=\"0\" y=\"0\" z=\"" + maxIndex + "\" p=\"100\" ht=\"0\" hv=\"0\" vt=\"0\" vv=\"0\" enable=\"1\">" +
                        "</div>" +
                        "<div class=\"logoright\">" +
                            "<div class=\"uploadlogo\"><a href=\"javascript:;\" class=\"button\" id=\"r-page-" + nowPage + "-upload-" + maxItem + "\" onclick=\"UploadLogo(" + nowPage + "," + maxItem + ");\">选图片</a></div>" +
                            "<div class=\"resizelogo\"><span>调整大小：</span><span class=\"slider ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all\" id=\"r-page-" + nowPage + "-slider-" + maxItem + "\" aria-disabled=\"false\"><a class=\"ui-slider-handle ui-state-default ui-corner-all\" href=\"#\" style=\"left: 33.33333333333333%;\"></a></span><a href=\"javascript:;\" class=\"hidelogo\" id=\"hide-" + nowPage + "-image-" + maxItem + "\" onclick='DeleteItem(" + nowPage + ",\"image\"," + maxItem + ");'>删</a></div>" +
                        "</div>" +
                        "</li>";

                    $("#r-page-" + nowPage + " .logoItems ul").append(imgstr);

                    var imgitem = "<img src=\"" + bValue + "\" class=\"preimg ui-draggable\" id=\"l-page-" + nowPage + "-image-" + maxItem + "\" style=\"left:0px; top: 0px;width: " + width + "px; height:" + height + "px; z-index:" + maxIndex + ";\">";

                    $("#l-page-" + nowPage + " .pageContent").append(imgitem);

                    maxItem = maxItem + 1;
             
                    EventBind();

                    $(".slider").slider({
                        min: 0,
                        max: 300,
                        value: 100,
                        stop: function (event, ui) {
                            ResizeImage($(this).attr("id"), ui.value);
                        },
                        slide: function (event, ui) {
                            ResizeImage($(this).attr("id"), ui.value);
                        }
                    });
                    OpenAdvantageTools();
                }
            }
        },
        cancel: function () {

        }
    });


}
function ResizeImage(id, value) {
    var slidervalues = id.split('-');
    var sliderpage = slidervalues[2];
    var slidertype = slidervalues[3];
    var slideritem = slidervalues[4];
    var ow = $("#r-page-" + sliderpage + "-image-" + slideritem).attr("ow");
    var oh = $("#r-page-" + sliderpage + "-image-" + slideritem).attr("oh");

    var nw = parseInt(ow * value / 100);
    var nh = parseInt(oh * value / 100);

    $("#r-page-" + sliderpage + "-image-" + slideritem).attr("w", nw).attr("h", nh);
    $("#l-page-" + sliderpage + "-image-" + slideritem).css("width", nw).css("height", nh);
}

function SaveTemplateData(type) {
    var template = new Template();
     if (/^(1[3-9]{1}[0-9]{9})/i.test($("#mobc").val()))
{
        $cel = $("#mobc").val();
}
     if (/^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(.[a-zA-Z]{1,6})/i.test($("#ema").val()))
{
        $ema = $("#ema").val();
}
    if (($("#txtDocumentName").val()!="") && ($cel!="") && ($ema!="")){
        template.Name = $("#txtDocumentName").val();
        template.Tel = $cel;
        template.Ema = $ema;
    }else{
        return;
    }
    template.Pass = $("#pass").val();
    template.Addtime = "";

    template.Cls = $("#cls").val();

    if (type == "document")
        template.Id = $("#hideDocumentId").val();
    else
        template.Id = 0;

    template.ProductTypeId = $("#hideProductId").val();
    template.SizeId = $("#hideSizeId").val();
    if ($("#ddlDocumentGroupList").val() != null && $("#ddlDocumentGroupList").val() != undefined && $("#ddlDocumentGroupList").val() != "")
        template.GroupId = $("#ddlDocumentGroupList").val();
    else
        template.GroupId = 1;
    template.Status = true;
    template.FilePath = "";

    if ($("#isround").prop("checked"))
        template.IsRound = true;
    else
        template.IsRound = false;


    $.each($(".pageItem"), function (p, pageitem) {
        var page = new TemplatePage();
        var pageid = $(pageitem).attr("id").split('-')[2];
        page.Number = pageid;
        var back = $("#l-page-" + pageid).find(".pageBackground input").eq(0).val();
        page.Background = back;
        $.each($(pageitem).find(".logoitem"), function (i, imageItem) {
            var ojb = $(imageItem).find("img");
            $.each($(ojb), function (n, v) {
                if ($(v).attr("enable") == "1") {
                    var imageObj = new ImageItem();
                    imageObj.Width = parseInt($(v).attr("w"));
                    imageObj.Height = parseInt($(v).attr("h"));                    
                    imageObj.Imagetype = $(v).attr("t");
                    imageObj.ImageUrl = $(v).attr("src");
                    imageObj.Left = parseInt($(v).attr("x"));
                    imageObj.Top = parseInt($(v).attr("y"));
                    imageObj.ZIndex = parseInt($(v).attr("z"));
                    imageObj.Percent = $(v).attr("p");
                    imageObj.HAlignType = $(v).attr("ht");
                    imageObj.HAlignValue = $(v).attr("hv");
                    imageObj.VAlignType = $(v).attr("vt");
                    imageObj.VAlignValue = $(v).attr("vv");
                    page.Images.push(imageObj);
                }
            });
        });
        $.each($(pageitem).find(".textitem"), function (t, textItem) {
            var ojb = $(textItem).find("input");
            $.each($(ojb), function (n, v) {
                if ($(v).attr("enable") == "1") {
                    var textObj = new TextItem();
                    textObj.Text = $(v).val();
                    textObj.Left = parseInt($(v).attr("x"));
                    textObj.Top = parseInt($(v).attr("y"));
                    textObj.Width = parseInt($(v).attr("w"));
                    textObj.Height =parseInt( $(v).attr("h"));
                    textObj.RGBColor = $(v).attr("rc");
                    textObj.CMYKColor = $(v).attr("cc");
                    textObj.FontName = $(v).attr("fn");
                    textObj.FontSize = parseInt($(v).attr("fz"));
                    textObj.Fontstyle = $(v).attr("fs");
                    textObj.Fontweight = parseInt($(v).attr("fw"));
                    textObj.WordSpace = $(v).attr("s");
                    textObj.MultiLine = false;
                    textObj.Textdirection = $(v).attr("td");
                    textObj.TextTag = $(v).attr("tt");
                    textObj.ZIndex =parseInt( $(v).attr("z"));
                    textObj.HAlignType = $(v).attr("ht");
                    textObj.HAlignValue = $(v).attr("hv");
                    textObj.VAlignType = $(v).attr("vt");
                    textObj.VAlignValue = $(v).attr("vv");
                    page.Texts.push(textObj);
                }
            });
        });
        template.Pages.push(page);
    });
    var data = $.toJSON(template);
    return data;
}

function SaveTemplate(isprint, type) {
    
        art.dialog({
            drag: true,
            title: '保存名片',
            content: document.getElementById("SaveTemplate"),
            lock: true,
            ok: function () {
                var json = SaveTemplateData(type);
                var saveUrl="";
                if (json == ""){
                    return;}
                else
                    if (type == "template")
                      saveUrl = "save.php?act=mp";
                    else
                      saveUrl = "save.php?act=mp";
                
                
                
                $.ajax({
                    type: "POST",
                    url: saveUrl,
                    datatype: "json",
                    async: false,
                    data: "data=" + json,
                    success: function (data) {
                        if (isprint == 1) {
                            $.ajax({
                                url: 'save.php?act=mp',
                                type: 'POST',
                                data: 'id=' + data + '&action=add',
                                dataType: 'html',
                                timeout: 60000,
                                success: function (data) {
                                    window.location = "save.php?act=mp";
                                }
                            });
                        } else {
                            art.dialog.tips('保存成功！');
                            //跳转
                            location.href="i.php?act="+data;
                        }
                    },
                    error: function () {
                        art.dialog.tips('保存失败！');
                    }
                });
            },
            cancel: function () {
            }
        });
}

function Saveewm() {
    
        art.dialog({
            drag: true,
            title: '二维码名片',
            content: document.getElementById("SaveEwm"),
            lock: true,
            ok: function () {
                var json = Saveewmdata("SaveEwm");
                
                var saveUrl="";
                var isprint = 0;
                if (json == ""){
                    return;}
                else
                    saveUrl = "save.php?act=png";
                
                
                
                $.ajax({
                    type: "POST",
                    url: saveUrl,
                    async: false,
                    datatype: "json",
                    data: "data=" + json,
                    success: function (rdata) {
                        if (isprint == 1) {
                            $.ajax({
                                url: 'save.php?act=png',
                                type: 'POST',
                                data: 'id=' + data + '&action=add',
                                dataType: 'html',
                                timeout: 60000,
                                success: function (data) {
                                    window.location = "save.php?act=png&ProductId=" + $("#hideProductId").val();
                                }
                            });
                        } else {
                           //art.dialog.tips('保存成功！');
                            //跳转location.href="img.php";
                          
            var bValue = rdata;
            var img = new Image();
            img.src = bValue;
            img.onload = function () {
                if (img.complete == true) {
                    var width = img.width;
                    var height = img.height;

                    maxItem++;
                    maxIndex++;
                    var imgstr = "<li class=\"logoitem\">" +
                        "<div class=\"logoleft\">" +
                            "<img src=\"" + bValue + "\" id=\"r-page-" + nowPage + "-image-" + maxItem + "\" ow=\"" + width + "\" oh=\"" + height + "\" w=\"" + width + "\" h=\"" + height + "\" t=\"1\" x=\"0\" y=\"0\" z=\"" + maxIndex + "\" p=\"100\" ht=\"0\" hv=\"0\" vt=\"0\" vv=\"0\" enable=\"1\">" +
                        "</div>" +
                        "<div class=\"logoright\">" +
                            "<div class=\"uploadlogo\"><a href=\"javascript:;\" class=\"button\" id=\"r-page-" + nowPage + "-upload-" + maxItem + "\" onclick=\"UploadLogo(" + nowPage + "," + maxItem + ");\">选图片</a></div>" +
                            "<div class=\"resizelogo\"><span>调整大小：</span><span class=\"slider ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all\" id=\"r-page-" + nowPage + "-slider-" + maxItem + "\" aria-disabled=\"false\"><a class=\"ui-slider-handle ui-state-default ui-corner-all\" href=\"#\" style=\"left: 33.33333333333333%;\"></a></span><a href=\"javascript:;\" class=\"hidelogo\" id=\"hide-" + nowPage + "-image-" + maxItem + "\" onclick='DeleteItem(" + nowPage + ",\"image\"," + maxItem + ");'>删</a></div>" +
                        "</div>" +
                        "</li>";

                    $("#r-page-" + nowPage + " .logoItems ul").append(imgstr);

                    var imgitem = "<img src=\"" + bValue + "\" class=\"preimg ui-draggable\" id=\"l-page-" + nowPage + "-image-" + maxItem + "\" style=\"left:0px; top: 0px;width: " + width + "px; height:" + height + "px; z-index:" + maxIndex + ";\">";

                    $("#l-page-" + nowPage + " .pageContent").append(imgitem);

                    maxItem = maxItem + 1;
             
                    EventBind();

                    $(".slider").slider({
                        min: 0,
                        max: 300,
                        value: 100,
                        stop: function (event, ui) {
                            ResizeImage($(this).attr("id"), ui.value);
                        },
                        slide: function (event, ui) {
                            ResizeImage($(this).attr("id"), ui.value);
                        }
                    });
                    OpenAdvantageTools();
                }
            }
        

                        }
                    },
                    error: function () {
                        art.dialog.tips('保存失败！');
                    }
                });
            },
            cancel: function () {
            }
        });
}

function DownTemplate(type) {
    var json = SaveTemplateData(type);
    var form = $("<form>");
    form.attr('style', 'display:none');
    form.attr('target', '');
    form.attr('method', 'post');
    if (type == "template")
        form.attr('action', 'save.php');
    else
        saveUrl = "save.php";
    var input = $('<input>');
    input.attr('type', 'hidden');
    input.attr('name', 'data');
    input.attr('value', json);
    $('body').append(form);
    form.append(input);
    form.submit();
    form.remove();
}

function AddPrint(id, action) {
    $.ajax({
        url: 'AjaxPage/ChangePrintList.aspx',
        type: 'POST',
        data: 'id=' + id + '&action=' + action,
        dataType: 'html',
        timeout: 60000,
        success: function (data) {
            MyPrintList();
        }
    });
}

function GetText(page, number) {
    var lObj = $("#l-page-" + page + "-text-" + number);
    var rObj = $("#r-page-" + page + "-text-" + number);

    var textValue = $(rObj).val();
    var textFamily = $(rObj).attr("fn");
    var textSize = parseInt($(rObj).attr("fz"));
    var textColor = $(rObj).attr("rc");
    var textBold = $(rObj).attr("fw");
    var textItalic = $(rObj).attr("fs");
    var textMultiline = $(rObj).attr("m");
    var textSpace = $(rObj).attr("s");

    var textHAlignType = $(rObj).attr("ht");
    var textHAlignValue = $(rObj).attr("hv");
    var textVAlignType = $(rObj).attr("vt");
    var textVAlignValue = $(rObj).attr("vv");
    var textWidth = $(rObj).attr("w");
    var textHeight = $(rObj).attr("h");
    var textLeft = $(rObj).attr("x");
    var textTop = $(rObj).attr("y");

    //alert(textBold);
    var imgsrc = "AjaxPage/gettext.php?Text=" + encodeURIComponent(textValue) + "&FontName=" + encodeURIComponent(textFamily) + "&FontSize=" + textSize + "&RGBColor=" + encodeURIComponent(textColor) + "&Fontweight=" + textBold + "&Fontstyle=" + textItalic;
    var image = new Image();
    image.src = imgsrc;
    if (textHAlignType=="")
    {

    }
    else
    {

    }
    if (textHAlignValue == "") {
    }
    else {
    }

    $(lObj).attr("src", imgsrc);
}
function AddNewText() {
    maxItem++;
    maxIndex++;
    var inputstr = "<li class=\"textitem\" id=\"r-page-" + nowPage + "-li-" + maxItem + "\">" +
     "<input type=\"text\" class=\"inputtext\" value=\"这里输入文字\" x=\"4\" y=\"98\" w=\"182\" h=\"35\" rc=\"#000000\" " +
     "cc=\"0-0-100-0\" s=\"0\" fn=\"fz.TTF\" fz=\"12\" fw=\"0\" fs=\"0\"" +
     "m=\"False\" td=\"1\" tt=\"8\" z=\""+maxIndex+"\" ht=\"0\" hv=\"0\" vt=\"0\" vv=\"0\"" +
     "id=\"r-page-" + nowPage + "-text-" + maxItem + "\" enable=\"1\" onblur=\"GetText(" + nowPage + "," + maxItem + ");\" onfocus=\"SetFontStyle(" + nowPage + "," + maxItem + ");\" onkeyup=\"GetText(" + nowPage + "," + maxItem + ")\">" +
     "<a href=\"javascript:;\" class=\"hidelogo\" id=\"hide-" + nowPage + "-text-" + maxItem + "\" onclick=\"DeleteItem(" + nowPage + ",'text'," + maxItem + ");\">隐</a>" +
     "</li>";
    $("#r-page-" + nowPage + " .textItems ul").append(inputstr);
    var imgsrc = GetImg("这里输入文字", "fz.TTF", 20, "#000000", "0", "0");
    var imgitem = "<img " +
    " src=\"" + imgsrc + "\" " +
    " id=\"l-page-" + nowPage + "-text-" + maxItem + "\"" +
    " class=\"preimg ui-draggable\"" +
    " style=\"left:224px;top:98px;z-index:" + maxIndex + ";\"" +
    " />";
    $("#l-page-" + nowPage + " .pageContent").append(imgitem);
    EventBind();
    maxItem = maxItem + 1;

    OpenAdvantageTools();
}
function GetImg(textValue, textFamily, textSize, textColor, textBold, textItalic) {
    var imgsrc = "AjaxPage/gettext.php?Text=" + encodeURIComponent(textValue) + "&FontName=" + encodeURIComponent(textFamily) + "&FontSize=" + textSize + "&RGBColor=" + encodeURIComponent(textColor) + "&Fontweight=" + textBold + "&Fontstyle=" + textItalic;
    return imgsrc;
}

function SetFontStyle(page, index) {
    var textobj = $("#r-page-" + page + '-text-' + index);
    var selectItem = $("#r-page-" + page + '-li-' + index);
    $(selectItem).append($('#SetFontStyleTool'));
    $('#SetFontStyleTool').show();
    $('#ddlFontList').val($(textobj).attr('fn'));
    $('#FontSizeList').val($(textobj).attr('fz'));
    if ($(textobj).attr('fw') == "1")
        $("#IsBold").prop("checked", true);
    else
        $("#IsBold").prop("checked", false);

    if ($(textobj).attr('fs') == "1")
        $("#IsItalic").prop("checked", true);
    else
        $("#IsItalic").prop("checked", false);

    $("#ColorPickerBox").css("background-color", $(textobj).attr('rc'));
    $(selectItem).parent().find('li').removeClass("textitemFocus");
    $(selectItem).addClass("textitemFocus");
    var lid = "l" + $(textobj).attr("id").substring(1);
    $(".preimg").removeClass("ui-selected");
    $(".inputtext").removeClass("selectedtext");
    $("#" + lid).addClass("ui-selected");
    $(textobj)[0].focus();
}
function ChangeFontStyle() {
    var obj = $("#FontSizeList").parent().parent().find('input');
    if ($("#ddlFontList").val() != "") {
        $(obj).attr('fn', $("#ddlFontList").val());
    }
    if ($("#FontSizeList").val() != "") {
        $(obj).attr('fz', $("#FontSizeList").val());
    }
    if ($("#IsBold").prop("checked"))
        $(obj).attr('fw', 1);
    else
        $(obj).attr('fw', 0);
    if ($("#IsItalic").prop("checked"))
        $(obj).attr('fs', 1);
    else
        $(obj).attr('fs', 0);
    var id = $(obj).attr("id");
    var pageid = id.split('-')[2];
    var itemid = id.split('-')[4];
    GetText(pageid, itemid);
}
function SetFontColor() {
    var obj = $("#ColorPickerBox").parent().parent().find('input');
    $(obj).attr("rc", currentColor);
    $(obj).attr("cc", currentColorCMYK);
    $("#ColorPickerBox").css("background-color", currentColor);
    var id = $(obj).attr("id");
    var pageid = id.split('-')[2];
    var itemid = id.split('-')[4];
    GetText(pageid, itemid);
}

function SaveGroupName() {
    var groupName = encodeURIComponent($("#txtGroupName").val());
    var productId = $("#hideProductId").val();
    var isDefault = 0;
    $.ajax({
        type: "POST",
        url: "AjaxPage/AddGroup.ashx",
        datatype: "json",
        data: "GroupName=" + groupName + "&ProductId=" + productId + "&IsDefault=" + isDefault,
        success: function (data) {
           var group=$.evalJSON(data);
           var optionstr = "<option value=" + group.Id + ">" + group.Name + "</option>";
           $("#ddlDocumentGroupList").append(optionstr);
           $("#ddlDocumentGroupList").val(group.Id);
           $("#newdocumentgroupinfo").hide();
        },
        error: function () {
            alert("保存失败");
        }
    });
}

function GetMydDocs() {
    $.ajax({
        type: "POST",
        url: "AjaxPage/GetDocument.ashx",
        dataType: "json",
        data: "ProductId=" + $("#hideProductId").val(),
        success: function (data) {
            var htmlstr = "";
            $(".hot-mp-list ul").html(htmlstr);
            if (data != -1) {
                $.each(data, function (n, v) {
                    htmlstr += "<li>" +
                                    "<div>" +
                                       "<a href='DocumentEdit.aspx?ProductId=" + $("#hideProductId").val() + "&DocumentId=" + v.Id + "' class='templatethumb'>" +
                                            "<img src='/" + v.ProductType.Code + "/Files/DocFiles/Thumbs/" + v.Thumb1 + "' alt='" + v.Name + "'/></a>" +
                                    "</div>" +
                                    "<p>" +
                                       "<a class='lefttitle' href='DocumentEdit.aspx?ProductId=" + $("#hideProductId").val() + "&DocumentId=" + v.Id + "'>" + v.Name + "</a>" +
                                       "<a class='rightbutton' href='javascript:;' onclick='AddPrint(" + v.Id + ",\"add\");'>印刷</a>" +
                                    "</p>" +
                             "</li>";
                });
                $("#ShowNoTemplate").hide();
                $(".hot-mp-list ul").html(htmlstr);
            } else {
                $("#ShowNoTemplate").show();
            }
        },
        error: function (a) {
            alert($("#hideProductId").val());
        }
    });
}

function AddNewGroup() {
    $("#newdocumentgroupinfo").show();
}
/////*
////设置字体的对齐方向
////*/
var SetAlignLeft = function () {
    $.each(SelectedItems, function (n, value) {
        $(value).css("text-align", "left");
        $(value).attr("haligntype", "self");
        $(value).attr("halignvalue", "left");
    });
}
var SetAlignRight = function () {
    $.each(SelectedItems, function (n, value) {
        $(value).css("text-align", "right");
        $(value).attr("haligntype", "self");
        $(value).attr("halignvalue", "right");
    });
}
var SetAlignCenter = function () {
    $.each(SelectedItems, function (n, value) {
        $(value).css("text-align", "center");
        $(value).attr("haligntype", "self");
        $(value).attr("halignvalue", "center");
    });
}
/////*
////设定两个及以上各元素的对齐方式
////*/
var HoriLeft = function () {
    var minLeft = 1000;
    $.each(SelectedItems, function (n, value) {
        var meLeft = parseInt($(value).css("left"));
        if (meLeft < minLeft)
            minLeft = meLeft;
    });
    $.each(SelectedItems, function (n, value) {
        $(value).css("left", minLeft).css("text-align", "left");
        var rightItemId = "#r"+$(value).attr("id").substring(1);
        $(rightItemId).attr("ht", "0");
        $(rightItemId).attr("hv", "0");
        $(rightItemId).attr("x", minLeft);
    });
}

var HoriRight = function () {
    var maxRight = 0;
    $.each(SelectedItems, function (n, value) {
        var meLeft = parseInt($(value).css("left"));
        var meWidth = parseInt($(value).css("width"));
        var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
        var oWidth = 0;
        if ($(value).css("width").toUpperCase() != "AUTO")
            oWidth = meWidth;
        else
            oWidth = meOffsetWidth;
        if (meLeft + oWidth > maxRight)
            maxRight = meLeft + oWidth;
    });
    $.each(SelectedItems, function (n, value) {
        var meWidth = parseInt($(value).css("width"));
        var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
        var oWidth = 0;
        if ($(value).css("width") && $(value).css("width").toUpperCase() != "AUTO") {
            oWidth = meWidth;
        } else {
            oWidth = meOffsetWidth;
        }
        $(value).css("left", maxRight - oWidth).css("text-align", "right");

        var rightItemId = "#r" + $(value).attr("id").substring(1);
        $(rightItemId).attr("ht", "0");
        $(rightItemId).attr("hv", "2");
        $(rightItemId).attr("x", maxRight - oWidth);
    });
}

var VertTop = function () {
    var minTop = 1000;
    $.each(SelectedItems, function (n, value) {
        var meTop = parseInt($(value).css("top"));
        if (meTop < minTop)
            minTop = meTop;
    });
    $.each(SelectedItems, function (n, value) {
        $(value).css("top", minTop);

        var rightItemId = "#r" + $(value).attr("id").substring(1);
        $(rightItemId).attr("vt", "0");
        $(rightItemId).attr("vv", "1");
        $(rightItemId).attr("y", minTop);
    });
}

var VertBottom = function () {
    var maxBottom = 0;
    $.each(SelectedItems, function (n, value) {
        var meTop = parseInt($(value).css("top"));
        var oHeight = 0;
        if ($(value).css("height") && $(value).css("height").toUpperCase() != "AUTO") {
            oHeight = parseInt($(value).css("height"));
        } else {
            oHeight = parseInt($(value).get(0).offsetHeight);
        }
        if (meTop + oHeight > maxBottom)
            maxBottom = meTop + oHeight;
    });
    $.each(SelectedItems, function (n, value) {
        var meTop = parseInt($(value).css("top"));
        var oHeight = 0;
        if ($(value).css("height") && $(value).css("height").toUpperCase() != "AUTO") {
            oHeight = parseInt($(value).css("height"));
        } else {
            oHeight = parseInt($(value).get(0).offsetHeight);
        }
        $(value).css("top", maxBottom - oHeight);

        var rightItemId = "#r" + $(value).attr("id").substring(1);
        $(rightItemId).attr("vt", "0");
        $(rightItemId).attr("vv", "1");
        $(rightItemId).attr("y", maxBottom - oHeight);
    });
}

var HoriCenter = function () {
    var minTop = 1000;
    var maxBottom = 0;

    $.each(SelectedItems, function (n, value) {
        var meTop = parseInt($(value).css("top"));
        var meLeft = parseInt($(value).css("left"));
        var meWidth = parseInt($(value).css("width"));
        var meHeight = parseInt($(value).css("height"));
        var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
        var meOffsetHeight = parseInt($(value).get(0).offsetHeight);

        var oHeight = 0;
        if ($(value).css("height") && $(value).css("height").toUpperCase() != "AUTO")
            oHeight = meHeight;
        else
            oHeight = meOffsetHeight;
        if (meTop < minTop)
            minTop = meTop;
        if (meTop + oHeight > maxBottom)
            maxBottom = meTop + oHeight;
    });

    var centerValue = (maxBottom + minTop) / 2;
    $.each(SelectedItems, function (n, value) {
        var meTop = parseInt($(value).css("top"));
        var meLeft = parseInt($(value).css("left"));
        var meWidth = parseInt($(value).css("width"));
        var meHeight = parseInt($(value).css("height"));
        var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
        var meOffsetHeight = parseInt($(value).get(0).offsetHeight);

        var oHeight = 0;
        if ($(value).css("height") && $(value).css("height").toUpperCase() != "AUTO")
            oHeight = meHeight;
        else
            oHeight = meOffsetHeight;
        $(value).css("top", centerValue - parseInt(oHeight / 2));


        var rightItemId = "#r" + $(value).attr("id").substring(1);
        $(rightItemId).attr("ht", "0");
        $(rightItemId).attr("hv", "1");
        $(rightItemId).attr("y", centerValue - parseInt(oHeight / 2));
    });
}

var VertMiddle = function () {
    var minLeft = 1000;
    var maxRight = 0;

    $.each(SelectedItems, function (n, value) {
        var meTop = parseInt($(value).css("top"));
        var meLeft = parseInt($(value).css("left"));
        var meWidth = parseInt($(value).css("width"));
        var meHeight = parseInt($(value).css("height"));
        var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
        var meOffsetHeight = parseInt($(value).get(0).offsetHeight);

        if ($(value).css("width") && $(value).css("width").toUpperCase() != "AUTO") {
            oWidth = meWidth;
        } else {
            oWidth = meOffsetWidth;
        }

        if (meLeft < minLeft)
            minLeft = meLeft;
        if (meLeft + oWidth > maxRight)
            maxRight = meLeft + oWidth
    });

    var centerValue = (maxRight + minLeft) / 2;
    $.each(SelectedItems, function (n, value) {
        var meWidth = parseInt($(value).css("width"));
        var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
        var oWidth = 0;
        if ($(value).css("width") && $(value).css("width").toUpperCase() != "AUTO")
            oWidth = meWidth;
        else
            oWidth = meOffsetWidth;
        $(value).css("left", centerValue - parseInt(oWidth / 2));
        $(value).css("text-align", "center");

        var rightItemId = "#r" + $(value).attr("id").substring(1);
        $(rightItemId).attr("vt", "0");
        $(rightItemId).attr("vv", "1");
        $(rightItemId).attr("x", centerValue - parseInt(oWidth / 2));
    });
}
/////*
////设置3个及以上元素的分布方式
////*/
var HoriAverage = function () {
    var index = 0;
    var maxRight = 0;
    var minLeft = 1000;
    var addWidth = 0;
    var leftArr = $([]);
    if (SelectedItems.length > 2) {
        $.each(SelectedItems, function (n, value) {
            var meTop = parseInt($(value).css("top"));
            var meLeft = parseInt($(value).css("left"));
            var meWidth = parseInt($(value).css("width"));
            var meHeight = parseInt($(value).css("height"));
            var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
            var meOffsetHeight = parseInt($(value).get(0).offsetHeight);

            var oWidth = 0;

            if ($(value).css("width") && $(value).css("width").toUpperCase() != "AUTO") {
                oWidth = meWidth;
            } else {
                oWidth = meOffsetWidth;
            }

            if (meLeft < minLeft)
                minLeft = meLeft;
            if (meLeft + oWidth > maxRight)
                maxRight = meLeft + oWidth;
            addWidth += oWidth;
            leftArr.push($(value));
            index++;
        });

        this.OrderByLeft(leftArr);
        var totalSpace = maxRight - minLeft - addWidth;
        if (totalSpace >= 0 && leftArr.length >= 2) {
            var perSpace = parseInt(totalSpace / (leftArr.length - 1));
            var currentLeft = parseInt($(leftArr[0]).css("left"));
            $.each(leftArr, function (n, value) {
                var meTop = parseInt($(value).css("top"));
                var meLeft = parseInt($(value).css("left"));
                var meWidth = parseInt($(value).css("width"));
                var meHeight = parseInt($(value).css("height"));
                var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
                var meOffsetHeight = parseInt($(value).get(0).offsetHeight);

                var oWidth = 0;
                if ($(value).css("width") && $(value).css("width").toUpperCase() != "AUTO") {
                    oWidth = meWidth;
                    
                } else {
                    oWidth = meOffsetWidth;
                }

                $(value).css("left", currentLeft);
                var rightItemId = "#r" + $(value).attr("id").substring(1);
                $(rightItemId).attr("x", currentLeft);
                currentLeft += perSpace;
                currentLeft += oWidth;
            });
        }
    } else {
        alert("排列请至少选择3个对象");
    }
}

var VertAverage = function () {
    var index = 0;
    var maxBottom = 0;
    var minTop = 1000;
    var addHeight = 0;
    var topArr = [];
    if (SelectedItems.length > 2) {
        $.each(SelectedItems, function (n, value) {
            var meTop = parseInt($(value).css("top"));
            var meLeft = parseInt($(value).css("left"));
            var meWidth = parseInt($(value).css("width"));
            var meHeight = parseInt($(value).css("height"));
            var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
            var meOffsetHeight = parseInt($(value).get(0).offsetHeight);
            var oHeight = 0;
            if ($(value).css("height") && $(value).css("height").toUpperCase() != "AUTO") {
                oHeight = meHeight;
            } else {
                oHeight = meOffsetHeight;
            }
            if (meTop < minTop)
                minTop = meTop;
            if (meTop + oHeight > maxBottom)
                maxBottom = meTop + oHeight;
            addHeight += oHeight;
            topArr[index] = $(value);
            index++;
        });

        this.OrderByTop(topArr);
        var totalSpace = maxBottom - minTop - addHeight;
        if (totalSpace >= 0 && topArr.length >= 2) {
            var perSpace = parseInt(totalSpace / (topArr.length - 1));
            var currentTop = parseInt($(topArr[0]).css("top"));
            $.each(topArr, function (n, value) {
                var meTop = parseInt($(value).css("top"));
                var meLeft = parseInt($(value).css("left"));
                var meWidth = parseInt($(value).css("width"));
                var meHeight = parseInt($(value).css("height"));
                var meOffsetWidth = parseInt($(value).get(0).offsetWidth);
                var meOffsetHeight = parseInt($(value).get(0).offsetHeight);
                var oHeight = 0;
                if ($(value).css("height") && $(value).css("height").toUpperCase() != "AUTO") {
                    oHeight = meHeight;
                } else {
                    oHeight = meOffsetHeight;
                }
                //alert(currentTop);
                $(value).css("top", currentTop);
                var rightItemId = "#r" + $(value).attr("id").substring(1);
                $(rightItemId).attr("y", currentTop);

                currentTop += perSpace;
                currentTop += oHeight;
            });
        }
    } else {
        alert("排列请至少选择3个对象");
    }
}
//////对齐方式辅助处理
var OrderByLeft = function (leftArr) {
    for (var i = 0; i < leftArr.length - 1; i++) {
        for (var j = 0; j < leftArr.length - 1; j++) {
            var left1 = parseInt($(leftArr[j]).css("left"));
            var left2 = parseInt($(leftArr[j + 1]).css("left"));
            if (left1 > left2) {
                this.Swap(j, j + 1, leftArr);
            }
        }
    }
}
var OrderByTop = function (topArr) {
    for (var i = 0; i < topArr.length - 1; i++) {
        for (var j = 0; j < topArr.length - 1; j++) {
            var top1 = parseInt($(topArr[j]).css("top"));
            var top2 = parseInt($(topArr[j + 1]).css("top"));
            if (top1 > top2) {
                this.Swap(j, j + 1, topArr);
            }
        }
    }

}
var Swap = function (index1, index2, objArr) {
    var tempobj = objArr[index1];
    objArr[index1] = objArr[index2];
    objArr[index2] = tempobj;
}
/////*
////元素相对于页面的对齐方式
////*/
var ToPageLeft = function () {
    $.each(SelectedItems, function (n, value) {
        $(value).css("left", 0);
        $(value).css("text-align", "left");
        $(value).attr("haligntype", "page");
        $(value).attr("halignvalue", "left");
    });
}
var ToPageTop = function () {
    $.each(SelectedItems, function (n, value) {
        $(value).css("top", 0);
        $(value).attr("valigntype", "page");
        $(value).attr("valignvalue", "top");
    });
}
var ToPageRight = function () {
    var pageWidth = parseInt($(".TemplatePageContent").css("width"));
    $.each(SelectedItems, function (n, value) {
        var meWidth = parseInt($(value).css("width"));
        $(value).css("left", pageWidth - meWidth);
        $(value).css("text-align", "right");
        $(value).attr("haligntype", "page");
        $(value).attr("halignvalue", "right");
    });
}
var ToPageBottom = function () {
    var pageHeight = parseInt($(".TemplatePageContent").css("height"));
    $.each(SelectedItems, function (n, value) {
        var meHeight = parseInt($(value).css("height"));
        $(value).css("top", pageHeight - meHeight);
        $(value).attr("valigntype", "page");
        $(value).attr("valignvalue", "bottom");
    });
}
var ToPageCenter = function () {
    var pageWidth = parseInt($(".TemplatePageContent").css("width"));

    $.each(SelectedItems, function (n, value) {
        var meWidth = parseInt($(value).css("width"));
        $(value).css("left", (pageWidth - meWidth) / 2);
        $(value).css("text-align", "center");
        $(value).attr("haligntype", "page");
        $(value).attr("halignvalue", "center");
    });
}
var ToPageMiddle = function () {
    var pageHeight = parseInt($(".TemplatePageContent").css("height"));

    $.each(SelectedItems, function (n, value) {
        var meHeight = parseInt($(value).css("height"));
        $(value).css("top", (pageHeight - meHeight) / 2);
        $(value).attr("valigntype", "page");
        $(value).attr("valignvalue", "middle");
    });
}

function clearEventBubble(evt) {
    var Event = evt || event;
    if (Event.stopPropagation) evt.stopPropagation();
    else window.Event.cancelBubble = true;
    if (Event.preventDefault) evt.preventDefault();
    else window.Event.returnValue = false;
    return false;
}